Attribute VB_Name = "Calculation"
Private Const PI As Double = 3.1415926
Public QF As QuickField.Application

'   Steel keeper dimensions
Private Const XposBase As Double = -20
Private Const YposBase As Double = 40
Private Const skHigh As Double = 20
Private Const skWidth As Double = 40

Public Sub DoCalculation(Hc As Double, _
        Ymin As Double, YMax As Double, Step As Double)
    Set QF = CreateObject("QuickField.Application")
    QF.MainWindow.Visible = True
    
    '   Open the Magn1.pbm problem
    Dim prb As QuickField.Problem
    '   The Magn1 files are assumed
    '   to be situated in Magn1 subfolder under
    '   your VB project folder
    QF.DefaultFilePath = VB.App.Path & "\Magn1"
    Set prb = QF.Problems.Open("Magn1.pbm")
    
    SetCoerciveForce prb, Hc
    
    Dim yPos As Double, xPos As Double    ' Keeper position
    Dim force As Double ' Mechanical force
    Dim i As Integer    ' Loop counter
    For i = 1 To (YMax - Ymin) / Step + 1
        ' Modify the steel keeper position
        xPos = XposBase
        yPos = YposBase + Ymin + Step * (i - 1)
        MoveKeeper prb, xPos, yPos
       
        If prb.CanSolve Then prb.SolveProblem
        If prb.Solved Then
            prb.AnalyzeResults
            force = CalculateForce(prb.Result, xPos, yPos)
        End If
        MainDialog.DisplayStepResult yPos, force
    Next
    
    QF.Quit
    Set QF = Nothing
End Sub

Private Sub MoveKeeper(prb As QuickField.Problem, _
                ByVal left As Double, ByVal bottom As Double)

    Dim mdl As QuickField.Model
    prb.LoadModel
    Set mdl = prb.Model
    
    ' The Shapes collection that contains all the geometrical enitities in the nodel
    ' provides methods for adding edges and vertices
    With mdl.Shapes
        .RemoveMesh
        .LabeledAs(Block:="Steel Keeper").Delete
        .AddEdge QF.PointXY(left, bottom), QF.PointXY(left, bottom + skHigh)
        .AddEdge QF.PointXY(left, bottom + skHigh), QF.PointXY(left + skWidth, bottom + skHigh)
        .AddEdge QF.PointXY(left + skWidth, bottom + skHigh), QF.PointXY(left + skWidth, bottom)
        .AddEdge QF.PointXY(left + skWidth, bottom), QF.PointXY(left, bottom)
        .Nearest(QF.PointXY(left + skWidth / 2, bottom + skHigh / 2)).Blocks.Label = "Steel Keeper"
        .BuildMesh
    End With
    
    mdl.Save
    mdl.Close
End Sub

Private Sub SetCoerciveForce(prb As QuickField.Problem, ByVal Hc As Double)
    Dim lab As QuickField.Label
    Dim labCnt As LabelBlockMS
    
    Set lab = prb.Labels(qfBlock).Item("ALNICO up")
    Set labCnt = lab.Content
    labCnt.Coercive = QF.PointRA(Hc, PI / 2)
    lab.Content = labCnt
    
    Set lab = prb.Labels(qfBlock).Item("ALNICO down")
    Set labCnt = lab.Content
    labCnt.Coercive = QF.PointRA(Hc, -PI / 2)
    lab.Content = labCnt
    lab.DataDoc.Save
End Sub

Private Function CalculateForce(res As QuickField.Result, ByVal left As Double, ByVal bottom As Double) As Double
    Dim win As FieldWindow
    Set win = res.Windows(1)
    With win.Contour
        .AddLineTo QF.PointXY(left - 5, bottom - 0.5)
        .AddLineTo QF.PointXY(left + skWidth + 5, bottom - 0.5)
        .AddLineTo QF.PointXY(left + skWidth + 5, bottom + skHigh + 5)
        .AddLineTo QF.PointXY(left - 5, bottom + skHigh + 5)
        .AddLineTo QF.PointXY(left - 5, bottom - 0.5)
    End With
    CalculateForce = res.GetIntegral(qfInt_MaxwellForce).Abs
End Function

